namespace UnityEngine.Advertisements
{
    /// <summary>
    /// An enum representing the on-screen anchor position of the banner ad.
    /// </summary>
    public enum BannerPosition
    {
        /// <summary>
        /// Anchor the banner in the top-left corner of the screen.
        /// </summary>
        TOP_LEFT,
        /// <summary>
        /// Anchor the banner in the top-center of the screen.
        /// </summary>
        TOP_CENTER,
        /// <summary>
        /// Anchor the banner in the top-right corner of the screen.
        /// </summary>
        TOP_RIGHT,
        /// <summary>
        /// Anchor the banner in the bottom-left corner of the screen.
        /// </summary>
        BOTTOM_LEFT,
        /// <summary>
        /// Anchor the banner in the bottom-center of the screen.
        /// </summary>
        BOTTOM_CENTER,
        /// <summary>
        /// Anchor the banner in the bottom-right corner of the screen.
        /// </summary>
        BOTTOM_RIGHT,
        /// <summary>
        /// Anchor the banner in the center of the screen.
        /// </summary>
        CENTER
    }
}
