# Advertising FAQs  
## Overview
* **Account questions**
    * [Can I access the new dashboard with the same login credentials as before?](#can-i-access-the-new-dashboard-with-the-same-login-credentials-as-before-)
    * [How do I add users to my organization?](#how-do-i-add-users-to-my-organization-)
    * [Why can’t I see my apps?](#why-can-t-i-see-my-apps-)
* **Campaign performance questions**
    * [How can I improve my campaign’s performance?](#how-can-i-improve-my-campaign-s-performance-)
    * [Can I configure Campaigns to promote my other games?](#can-i-configure-campaigns-to-promote-my-other-games-)
    * [Can I block specific apps from showing my campaign?](#can-i-block-specific-apps-from-showing-my-campaign-)
    * [Why did my install volume change?](#why-did-my-install-volume-change-)

## Account questions
#### Can I access the new dashboard with the same login credentials as before?
Yes. Please log in to the new [dashboard](https://acquire.dashboard.unity3d.com) with the same credentials that you used before. 

#### How do I add users to my organization?
You must have owner or manager privileges to add new members to an organization. To do so, follow these steps:

1. [Sign in to your Unity account](https://id.unity.com/)
2. Select **Organizations** on the left navigation bar. This displays a list of organizations associated with your account. 
3. Navigate to the organization you wish to add a new member to, then select the **Manage** settings icon. 
4. On the organization profile page, select **Members & Groups** from the left navigation bar.
5. Select **+ Add members**.
6. Enter emails manually or copy paste from a list of emails. To add multiple members, separate email addresses with a space or comma, or enter each email on a new line.
7. Select a role for the new members you’re adding, then select **Next**. Note that you can only assign roles that are equal or less than your role.  
8. Review the settings, then select **Invite members**.

#### Why can’t I see my apps?
The most common cause of this is viewing the wrong organization. When you create a new UDN account, it also creates a new organization for you, but does not automatically set that organization as the default for that email. Verify that the correct organization is selected in the top-right corner of the dashboard. If you do not have access to the correct organization, you may request that the organization’s owner adds you. If the problem persists, please [contact Ad Ops](https://unityads.unity3d.com/help/help/contact). 

## Campaign performance FAQs
#### How can I improve my campaign’s performance?
Our machine learning algorithm will always work to find the best users for you. However, there are two main factors that contribute to a successful ad campaign: 

* Use engaging creatives that drive conversion rate.
* Make competitive CPI bids. 

The key to success is high user engagement. For more tips, please see documentation on [Optimizing campaigns](AdvertisingOptimization.md). We will continue updating this content to help you get the most out of your advertisements.

#### Can I configure Campaigns to promote my other games?
Yes! Cross-Promotion is an open beta feature that allows publishers to backfill ad Placements with promotions for their own games. A Cross-Promotion works just like regular advertisements, but drives traffic to your own apps. For more information on setting up a cross-promotional Campaign, click [here](MonetizationCrossPromotions.md).

#### Can I block specific apps from showing my campaign?
Yes. Please [contact the Ad Ops team](mailto:adops-support@unity3d.com) to inquire about blocking specific apps by their ID.

#### Why did my install volume change?
During the course of a campaign, it is natural to see some performance fluctuations. Though the figure may vary from campaign to campaign, a 10-15% variation from week to week is considered normal. However, a greater spike than this might indicate a deeper issue.

Some factors contributing to a decrease in volume include:

* **Underperforming creatives**: A gradual decrease in volume over time can suggest ad fatigue. The introduction of a new creative that resonates less with your audience can also cause decreased conversion rates, and thus a decrease in volume.
* **A change in the competitive advertiser-side landscape**: Our inventory is constantly changing and growing. Occasionally new campaigns vastly outperform the rest of our platform, thus receiving preferential publisher inventory. If this happens, you can raise your bids to compete for this inventory.
* **A change in publishers**: Rarely, a publisher will remove their traffic from the inventory altogether.
* **A tracking issue**: This could be due to an outage in your third-party tracking service, or an uncommunicated change to the postback or tracking URLs.

On the other side of the coin, the inverse reasons can cause increases in volume:

* **The addition of a well-matched publisher**: We constantly add new publishers. If we happen to add a publisher whose users are particularly engaged with your ads, you may see volume suddenly skyrocket.
* **High-performing new creatives**: Advertisers often see noticeable volume increases after conducting a trailer refresh. Rotating in new trailers approximately once per quarter is a best practice if resources permit.