# Help and resources 
## Support
To help us provide effective and timely support, please submit your support-related questions using the Contact form on the [Operate dashboard](https://operate.dashboard.unity3d.com/) (select the help icon in the top-right corner, then **Contact Support**). This form provides additional account information needed to expedite a response.

If you are unable to access the dashboard, please email us directly, and include the following details:

* The Game ID(s) related to the issue.
* Your Developer ID or Organization name.
* If unable to log in, the email address you're using to log in.
* If unable to add store details, the store URL of your published game.
* If awaiting campaign moderation, the name of the campaign.

See below for guidelines on which support team to contact.

### Unity Ads support team
The Support team handles general questions and any technical issues you may have integrating Unity Ads in your game.

If you have a technical issue, please provide a device log or debug output, along with clear steps to reproduce the issue, and a description of where ads appear in your game.

Lastly, please provide a list of products along with the version numbers of the SDK(s) used in those integrations:

* The Unity Ads Native Android SDK
* The Unity Ads Native iOS SDK
* The Unity Ads asset package

If you're using a framework or game engine other than Unity, please tell us which one and which version you're using.

To ensure the stability and reliability of your integration, please make sure you are using the latest version of Unity Ads.

**Contact Email:** [unityads-support@unity3d.com](mailto:unityads-support@unity3d.com)

### AdOps team
The AdOps team primarily handles questions related to running and optimizing ad campaigns for your games.

**Contact Email:** [adops-support@unity3d.com](mailto:adops-support@unity3d.com)

### Sales team
The Sales team will be happy to answer any of your business questions.

If you have any questions related to [payments, invoicing](MonetizationResourcesRevenueAndPayment.md), [revenue reporting](MonetizationResourcesStatistics.md), the [developer dashboard](MonetizationResourcesDashboardGuide.md), or any technical matters, please reach out to the [Unity Ads support team](mailto:unityads-support@unity3d.com) instead.

We look forward in hearing from you!

**Contact Email:** [msales@unity3d.com](mailto:msales@unity3d.com)

## Resources
### Unity Ads Support
* [Unity Ads forum](https://forum.unity3d.com/forums/unity-ads.67)
* [Unity Ads feedback and feature requests](https://feedback.unity3d.com/forums/unity/suggestions?utf8=%E2%9C%93&status=0&category=ads&view=hottest)

### Unity Ads downloads
* [Unity Ads Asset package for Unity](https://www.assetstore.unity3d.com/en/#!/content/66123)
* [Unity Ads SDK for iOS](https://github.com/Unity-Technologies/unity-ads-ios/releases)
* [Unity Ads SDK for Android](https://github.com/Unity-Technologies/unity-ads-android/releases)

### Unity Ads demos
* [Test app for Unity + Asset Store Ads SDK](https://github.com/Unity-Technologies/unity-ads-assetstore-test)
* [Space Ads: A Unity Ads demo for Unity 5.xx](https://github.com/Applifier/unity-ads-demo)
* [Unity Ads Helper: a drag-n-drop solution for Unity](https://github.com/Applifier/unity-ads-helper)
* [Unity Ads Android SDK example Project for Android Studio](https://github.com/Unity-Technologies/unity-ads-android/tree/master/app)
* [Unity Ads server-to-server redeem callback example](https://github.com/Applifier/unity-ads-s2s-callback-example)

### Unity Ads articles
* [How Next Games unlocked the secret to ad success, by Rick Armstrong - May 19, 2016](https://blogs.unity3d.com/2016/05/19/how-next-games-unlocked-the-secret-to-ad-success/)
* [Best practices for rewarded video ads, by Rick Armstrong - April 20, 2016](https://blogs.unity3d.com/2016/04/20/best-practices-for-rewarded-video-ads-2/)
* [New study reveals the future of mobile game monetization, by Rick Armstrong - April 6, 2016](https://blogs.unity3d.com/2016/04/06/new-study-reveals-the-future-of-mobile-game-monetization/)
* [Ad engagement sending Futureplay’s revenue through the roof, by Rick Armstrong - March 14, 2016](https://blogs.unity3d.com/2016/03/14/ad-engagement-sending-futureplays-revenue-through-the-roof/)
* [A Designer's Guide to Using Video Ads, by Oscar Clark - April 15, 2015](https://blogs.unity3d.com/2015/04/15/a-designers-guide-to-using-video-ads/)
* [Integrating Unity Ads, by Mike Geig - April 9, 2015](https://blogs.unity3d.com/2015/04/09/integrating-unity-ads/)

### IAP Promo resources
* [Overview](https://docs.unity3d.com/Manual/IAPPromo.html)
* [Integration](https://docs.unity3d.com/Manual/IAPPromoIntegration.html)
* [Product Catalogs](https://docs.unity3d.com/Manual/IAPPromoProducts.html)
* [Promotions](https://docs.unity3d.com/Manual/IAPPromoPromotions.html)
* [Best practices](MonetizationResourcesBestPractices.md)
* [How-to video: IAP catalogs](https://youtu.be/SGkzskwVMug)
* [How-to video: dashboard setup](https://youtu.be/Xbp38T6xis0)
* [How-to video: Placements](https://youtu.be/OSXAl82Ov9g)
* [Promo creative template](https://drive.google.com/file/d/1iMp-m9NY7g0Ck6b3BHpJyWeo7dJvu5rn/view)
* [Implementation code sample](https://drive.google.com/file/d/1NW4WucfzUFMALWelFs-v2aFWrLj5f2cc/view)
* [Knowledge Base FAQs](https://support.unity3d.com/hc/en-us/sections/360000059083-IAP-Promo)