﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class CharacterPlayer : MonoBehaviour
{
    public GameObject Character;
    public bool isRunning;
    public float horizontalMove;
    public float verticalMove;

    void Update()
    {
        if (Input.GetButton("Horizontal") || Input.GetButton("Vertical"))
        {
            Character.GetComponent<Animator>().Play("CharacterWalk");
            horizontalMove = Input.GetAxis("Horizontal") * Time.deltaTime * 150;
            verticalMove = Input.GetAxis("Vertical") * Time.deltaTime * 8;
            isRunning = true;
            transform.Rotate(0, horizontalMove, 0);
            transform.Translate(0, 0, verticalMove);
        }

        else
        {
            Character.GetComponent<Animator>().Play("CharacterIdle");
            isRunning = false;
        }
    }
}
