﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class PlayerController : MonoBehaviour
{
    public Rigidbody2D theRB;
    public float moveSpeed, jumpForce;

    private bool isGrounded;
    public Transform groundCheckPoint;
    public LayerMask whatIsGround;

    public Animator anim;

    public bool isKeyboard2;

    public float timeBetweenAttacks = .25f;
    private float attackCounter;


    // Start is called before the first frame update
    void Start()
    {
        
    }

    // Update is called once per frame
    void Update()
    {

        isGrounded = Physics2D.OverlapCircle(groundCheckPoint.position, .2f, whatIsGround);

        if(!isKeyboard2)
        {
        theRB.velocity = new Vector2(Input.GetAxisRaw("Horizontal") * moveSpeed, theRB.velocity.y);
        }

        if(isKeyboard2)
        {
        theRB.velocity = new Vector2(Input.GetAxisRaw("Keyboard2H") * moveSpeed, theRB.velocity.y);
        }
        

        anim.SetBool("isGrounded", isGrounded);
        anim.SetFloat("ySpeed", theRB.velocity.y);
        anim.SetFloat("speed", Mathf.Abs(theRB.velocity.x));

        if(theRB.velocity.x < 0)
        {
            transform.localScale = new Vector3(-1f, 1f, 1f);
        } 
        
        else if (theRB.velocity.x > 0)

        {
            transform.localScale = Vector3.one;
        }

        if(attackCounter > 0)
        {
            attackCounter = attackCounter - Time.deltaTime;

            theRB.velocity = new Vector2(0f, theRB.velocity.y);
        }

        if(Input.GetButtonDown("Jump") && isGrounded && !isKeyboard2)
        {
            theRB.velocity = new Vector2(theRB.velocity.x, jumpForce);
        }

        if(Input.GetButtonDown("Fire1") && isGrounded && !isKeyboard2)
        {
            Attack();
        }

        if(Input.GetButtonUp("Jump") && !isGrounded && theRB.velocity.y > 0f && !isKeyboard2)
        {
            theRB.velocity = new Vector2(theRB.velocity.x, theRB.velocity.y * .5f);
        }

         if(Input.GetButtonDown("Keyboard2AK") && isGrounded && isKeyboard2)
        {
            Attack();
        }

        if(Input.GetButtonDown("Keyboard2J") && isGrounded && isKeyboard2)
        {
            theRB.velocity = new Vector2(theRB.velocity.x, jumpForce);
        }

        if(Input.GetButtonUp("Keyboard2J") && !isGrounded && theRB.velocity.y > 0f && isKeyboard2)
        {
            theRB.velocity = new Vector2(theRB.velocity.x, theRB.velocity.y * .5f);
        }


    }

    public void Attack()
    {
        anim.SetTrigger("attack");

        attackCounter = timeBetweenAttacks;



    }
}