using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class PlayerHealthController : MonoBehaviour
{
    public int maxHealth = 3;
    private int currentHealth;

    public SpriteRenderer[] healthDisplay;
    public Sprite healthFull, healthEmpty;

    public Transform heartHolder;

    public float invincibilityTime, healthFlashTime = .2f;
    private float invincCounter, flashCounter;


    // Start is called before the first frame update
    void Start()
    {
        currentHealth = maxHealth;
    }

    // Update is called once per frame
    void Update()
    {
        if(invincCounter > 0)
        {
            invincCounter -= Time.deltaTime;

            flashCounter -= Time.deltaTime;

            if (flashCounter < 0)
            {
                flashCounter = healthFlashTime;

                heartHolder.gameObject.SetActive(!heartHolder.gameObject.activeInHierarchy);
            }

            if (invincCounter <= 0)
            {
                heartHolder.gameObject.SetActive(true);
            }
     

        if (Input.GetKeyDown(KeyCode.G))
           {
            DamagePlayer(1);
            }
        }
        

    }

    private void LateUpdate()
    {
        heartHolder.localScale = transform.localScale;
    }

    public void UpdateHealthDisplay()
    {
        switch(currentHealth)
        {
            case 3:
            healthDisplay[0].sprite = healthFull;
            healthDisplay[1].sprite = healthFull;
            healthDisplay[2].sprite = healthFull;
            break;

            case 2:
            healthDisplay[0].sprite = healthFull;
            healthDisplay[1].sprite = healthFull;
            healthDisplay[2].sprite = healthEmpty;
            break;

            case 1:
            healthDisplay[0].sprite = healthFull;
            healthDisplay[1].sprite = healthEmpty;
            healthDisplay[2].sprite = healthEmpty;
            break;

            case 0:
            healthDisplay[0].sprite = healthEmpty;
            healthDisplay[1].sprite = healthEmpty;
            healthDisplay[2].sprite = healthEmpty;
            break;
        }
    }

    public void DamagePlayer(int damageToTake)
    {
        if (invincCounter <= 0)
        {

            currentHealth -= damageToTake;

            if (currentHealth < 0)
            {
                currentHealth = 0;
            }

            UpdateHealthDisplay();

            if (currentHealth == 0)
            {
                gameObject.SetActive(false);
            }

            invincCounter = invincibilityTime;
        }


    }

}