using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.SceneManagement;


public class GameManager : MonoBehaviour
{
    public static GameManager instance;
    bool picked;
    int pairs;
    int pairCounter;

    List<Card> pickedCards = new List<Card>();

    void Awake()
    {
        instance = this;
    }

    public void AddCardToPickedList(Card card)
    {
        pickedCards.Add(card);

        if(pickedCards.Count ==2)
        {
            picked = true;
            StartCoroutine(CheckMatch());

        }


    }

    IEnumerator CheckMatch()
    {
        yield return new WaitForSeconds(1.5f);

        if(pickedCards[0].GetCardId() == pickedCards[1].GetCardId())
        {
            pickedCards[0].gameObject.SetActive(false);
            pickedCards[1].gameObject.SetActive(false);
            pairCounter++;
            CheckForWin();

        }

        else

        {
            pickedCards[0].FlipOpen(false);
            pickedCards[1].FlipOpen(false);
            yield return new WaitForSeconds(1.5f);
        }

        

        picked = false;

        pickedCards.Clear();



    }

    void CheckForWin()
    {
        if(pairs == pairCounter)
        {
            SceneManager.LoadScene(0);
        }
    }



    public bool HasPicked()
    {
        return picked;
    }

    public void SetPairs(int pairAmount)
    {
        pairs = pairAmount;
    }



}
