using System.Collections;
using System.Collections.Generic;
using UnityEngine;

[RequireComponent(typeof(Rigidbody))]
[RequireComponent(typeof(MeshCollider))]

public class Bumper : MonoBehaviour
{
    public int score;
    [SerializeField] float power = 1f;
    Animator anim;

    void Start()
    {
        anim = GetComponentInChildren<Animator>();

    }

    void OnCollisionEnter(Collision col)
    {
        foreach(ContactPoint contact in col.contacts)
        {
            ScoreManager.instance.AddScore(100);
            contact.otherCollider.attachedRigidbody.AddForce(-1 * contact.normal * power, ForceMode.Impulse);
        }

        if(anim != null)
        {
            anim.SetTrigger("activate");
        }
    }

}
