
using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.SceneManagement;

public class GameManager : MonoBehaviour
{
    public static GameManager instance;

    int startBallAmount = 3;
    int currentBallAmount;
    int activeBallsOnPlayfield;


    public GameObject ballPrefab;
    public Transform spawnPoint;

    public GameObject fadeout;

    void Awake()
    {
        instance = this;
    }

    void Start()
    {
        ResetGame();
    }

    void ResetGame()
    {
        currentBallAmount = startBallAmount;
        CreateNewBall();

    }

    public void CreateNewBall()
    {
        if (activeBallsOnPlayfield == 0 && currentBallAmount > 0)
        {
            Instantiate(ballPrefab, spawnPoint.position, Quaternion.identity);
            currentBallAmount--;
            UiManager.instance.UpdateBallText(currentBallAmount);
        }

        else
        {

            SceneManager.LoadScene(0);
        }
    }


}

