using System.Collections;
using System.Collections.Generic;
using UnityEngine;

[System.Serializable]
public class Mission
{
    public int missionId;
    [Space]
    public bool active;
    public bool missionComplete;
    [Space]
    public bool restartOnNextBall;
    public bool stopOnBallEnd;
    public bool resetOnComplete;
    [Space]
    public float timeToComplete;
    [Space]
    public int score;
    public int amountToComplete;
    public int currentAmount;
    [Space]
    public LightShows lightShow;

    public void ResetMission()
    {
        active = false;
        missionComplete = false;
        currentAmount = 0;

        if(lightShow != null)
        {
            lightShow.StopLightShow();
        }
    }

    public void DeactivateMission()
    {
        active = false;
        currentAmount = 0;

        if (lightShow != null)
        {
            lightShow.StopLightShow();
        }
    }

    public void UpdateMission()
    {
        if(active && !missionComplete)
        {
            currentAmount++;

            CheckMissionComplete();


        }
    }

    void CheckMissionComplete()
    {
        if(currentAmount >= amountToComplete)
        {
            missionComplete = true;
            active = false;

            if(timeToComplete > 0)
            {
                MissionManager.instance.StopTimer();
            }

            ScoreManager.instance.AddScore(score);

            ResetMission();
            Debug.Log("Wrap");
        }

    }

    public bool GetMissionActive()
    {
        return active;
    }
}
