using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class Target : MonoBehaviour
{
    [HideInInspector]
    bool isOut;
    Animator anim;
    Collider col;

    void Start()
    {
        anim = GetComponent<Animator>();
        col = GetComponent<Collider>();
    }

    public void Activate(bool on)
    {
        if(anim != null)
        {
            isOut = on;
            col.enabled = on;

            anim.SetBool("activate", on);
        }

        StartCoroutine(ResetTargets());
    }

    void OnCollisionEnter(Collision _col)
    {
        Activate(true);
        ScoreManager.instance.AddScore(50);
    }

    IEnumerator ResetTargets()
    {
        yield return new WaitForSeconds(2);
        Activate(false);
    }
}
