using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class Playfield : MonoBehaviour
{
    public static Playfield instance;

    const int numRows = 6;
    const int numCols = 7;

    int[,] board = new int[numRows,numCols]
    {
        {0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0}, 
        {0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0}, 
        {0,0,0,0,0,0,0},
    };

    // Start is called before the first frame update
    void Awake()
    {
        instance = this;
    }

    public int ValidMove(int column)
    {
        for(int i = numRows -1; i >= 0; i--)
        {
            if(column < numCols)
            {
                if(board[i, column] == 0)
                {
                    return i;
                }

            }

             
        }

        Debug.Log("No Valid Move");
        return -1;
    }

    public void DropCoin(int x, int y, int player)
    {
        board[x,y] = player;
        print(DebugBoard());

       GameManager.instance.WinCondition(WinCheck());

    }

    bool WinCheck()
    {
        if(HorizontalCheck() || VerticalCheck() || DiagonalCheck())
        {
            return true;
        }

        return false;
    }

    bool HorizontalCheck()
    {
        for(int row = 0; row < numRows; row++)
        {
            for (int column = 0; column < 4; column++)
            {
                if(board[row, column] > 0)
                {
                    int a = board[row, column];
                    int b = board[row, column +1];
                    int c = board[row, column +2];
                    int d = board[row, column +3];
                    if(a == b && a == c && a == d)
                    {
                        Debug.Log("WIN!" + a);
                        return true;
                    }
                }
            }
        }

        Debug.Log("NOPE");
        return false;
    }

    bool VerticalCheck()
    {
        for(int row = 0; row < 3; row++)
        {
            for (int column = 0; column < numCols; column++)
            {
                if(board[row, column] > 0)
                {
                    int a = board[row, column];
                    int b = board[row +1, column];
                    int c = board[row +2, column];
                    int d = board[row +3, column];

                    if(a == b && a == c && a == d)
                    {
                        Debug.Log("WIN !" + a);
                        return true;
                    }
                }
            }
        }

        Debug.Log("NOPE");
        return false;
    }

    bool DiagonalCheck()
    {
        for (int row = 0; row < 3; row++)
        {
            for (int column = 0; column < 4; column++)
            {
                if(board[row, column] > 0)
                {
                    int a = board[row, column];
                    int b = board[row +1, column +1];
                    int c = board[row +2, column +2];
                    int d = board[row +3 , column +3];
                    
                    if(a == b && a == c && a == d)
                    {
                        Debug.Log("WIN!" + a);
                        return true;
                    }
                }
            }
        }

         for (int row = 0; row < 3; row++)
        {
            for (int column = 3; column < numCols; column++)
            {
                if(board[row, column] > 0)
                {
                    int a = board[row, column];
                    int b = board[row +1, column -1];
                    int c = board[row +2, column -2];
                    int d = board[row +3 , column -3];
                    
                    if(a == b && a == c && a == d)
                    {
                        Debug.Log("WIN!" + a);
                        return true;
                    }
                }
            }
        } 

        Debug.Log("NOPE");
        return false;
    }

    string DebugBoard()
    {
        string s = "";
        string seperator = ",";
        string border = "|";

        for (int x = 0; x < numRows; x++)
        {
            s +=border;
            for (int y = 0; y < numCols; y++)
            {
                s +=board[x, y];
                s+= seperator;
            }

            s+= border + "\n";
        }

        return s;
    }

}
