using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class WeaponBlast : MonoBehaviour
{
    public GameObject theBlaster;
    public bool isFiring = false;
    public float targetDistance;
    public int damageAmount = 5;

    void Update()
    {
        if(Input.GetButtonDown("Fire1"))
        {
            if(isFiring == false)
            {
                StartCoroutine(BlastingNow());
            }
            
        }
    }

    IEnumerator BlastingNow()
    {
        RaycastHit theBlast;
        isFiring = true;

        if (Physics.Raycast(transform.position, transform.TransformDirection(Vector3.forward), out theBlast))
        {
            targetDistance = theBlast.distance;
            theBlast.transform.SendMessage("DamageEnemy", damageAmount, SendMessageOptions.DontRequireReceiver);
        }

        theBlaster.GetComponent<Animator>().Play("WeaponBlast");
        yield return new WaitForSeconds(0.5f);
        theBlaster.GetComponent<Animator>().Play("Idle");
        isFiring = false;

    }
}