﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.SceneManagement;

public class LoseCollider : MonoBehaviour
{
    public int playerLives = 3;

    private Level levelmanager;
    private Ball ball;
    private Paddle paddle;

    private void Awake()
    {
        int LoseColliderCount = FindObjectsOfType<LoseCollider>().Length;
        if (LoseColliderCount > 1)
        {
            gameObject.SetActive(false);
            Destroy(gameObject);
        }
        else
        {
            DontDestroyOnLoad(gameObject);
        }
        
     

    }

   private void OnTriggerEnter2D(Collider2D other)
   {
       playerLives--;
       if (playerLives <= 0)
       {
            SceneManager.LoadScene("GameOver");
            playerLives = 3;

       }
       else if (playerLives > 0)
       {
            ball = GameObject.FindObjectOfType<Ball>();
            paddle = GameObject.FindObjectOfType<Paddle>();
            ball.hasStarted = false;
            ball.transform.position = new Vector2(paddle.transform.position.x, 1.35f);
       }
   }
}
