﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class AI : MonoBehaviour
{

    public string hitTag;
    public bool lookingAtPlayer = false;
    public GameObject Chicken;
    public AudioSource ChickenSound;
    public bool isGrowling = false;
    public float growlRate = 2.5f;
    public GameObject ChickenHurt;

    void Update()
    {
        RaycastHit Hit;
        if (Physics.Raycast(transform.position, transform.TransformDirection(Vector3.forward), out Hit))
        {
            hitTag = Hit.transform.tag;
        }
        if (hitTag == "Player" && isGrowling == false)
        {

            StartCoroutine(ChickenRoar());
        }
        if (hitTag != "Player")
        {
            
            Chicken.GetComponent<Animator>().Play("Idle");
            lookingAtPlayer = false;
        }

        IEnumerator ChickenRoar()
        {
            isGrowling = true;
            Chicken.GetComponent<Animator>().Play("AttackB", -1, 0);
            Chicken.GetComponent<Animator>().Play("AttackB");
            ChickenHurt.SetActive(true);
            yield return new WaitForSeconds(0.5f);
            ChickenHurt.SetActive(false);
            ChickenSound.Play();
            lookingAtPlayer = true;
            GlobalHealth.healthValue -= 5;
            yield return new WaitForSeconds(growlRate);
            isGrowling = false;
        }

    }
}