using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class PlayerController : MonoBehaviour
{
    [SerializeField] float xMoveSpeed;
	[SerializeField] float yMoveSpeed;
	[SerializeField] float zMoveSpeed;
	
	Rigidbody myRigidBody;
	
	[SerializeField] GameObject bombPrefab;
	
    // Start is called before the first frame update
    void Start()
    {
      myRigidBody = GetComponent<Rigidbody>();
    }

    // Update is called once per frame
    void Update()
    {
		Movement();
		PlaceBomb();
	
}
void Movement()
{
	Vector3 newVelocity = new Vector3();
	  
	  if(Input.GetKey(KeyCode.W))
	  {
	  newVelocity = new Vector3 (0f, 0f, zMoveSpeed);
	  }
    else if (Input.GetKey(KeyCode.S))
	{
		newVelocity = new Vector3 (0f, 0f,-zMoveSpeed);
	}
	else if (Input.GetKey (KeyCode.A))
	{
		newVelocity = new Vector3 (0f, 0f, -xMoveSpeed);
	}
	else if (Input.GetKey (KeyCode.D))
	{
		newVelocity = new Vector3 (0f, 0f, xMoveSpeed);
	}
	
	myRigidBody.velocity = newVelocity;
	
    }

private void PlaceBomb()
{
	if(Input.GetKeyDown(KeyCode.Space))
	{
		GameObject bomb = Instantiate(bombPrefab, transform.position, Quaternion.identity);
		
	}
}
}
