# Tool panels

This portion of the ProBuilder toolbar provides access to most of the ProBuilder windows and components.

![Tool Panels on the ProBuilder toolbar](images/tool_panels.png)

> ***Note:*** Some actions also have extra options or custom settings available. The tool buttons have a special indicator in the top right corner (shown as a gear icon in the first tool icon in the image above). The documentation for each tool includes information about these options.

## ![Shape Tool icon](images/icons/Panel_Shapes.png) New Shape

Use the **Shape Tool** window to create new ProBuilder Mesh shapes such as cylinders, arches, and stairs.

For more information, see the [Shape Tool](shape-tool.md) window reference.

## ![Poly Shape Tool icon](images/icons/NewPolyShape.png) New Poly Shape

Use the **Poly Shape** component to create a custom 2-dimensional shape and then extrude that shape to create a custom 3-dimensional Mesh.

For more information, see the [Poly Shape](polyshape.md) component reference.

## ![Bezier Shape icon](images/icons/NewBezierSpline.png) New Bezier Shape

Use the **Bezier Shape** component to define a bezier curve around which ProBuilder extrudes a Mesh.

> ***Warning:*** Bezier shapes are experimental, meaning that they are still under development, and might reduce ProBuilder's stability. Please use with caution.

For more information, see the [Bezier Shape](bezier.md) component reference.

## ![Smoothing Groups icon](images/icons/Panel_Smoothing.png) Smoothing 

Use the **Smooth Group Editor** window to create a smooth and rounded look.

For more information, see the [Smooth Group Editor](smoothing-groups.md) window reference.

## ![Vertex Color icon](images/icons/Panel_VertColors.png) Vertex Colors

Use the **Vertex Colors** window to apply or paint vertex colors onto Meshes.

For more information, see the [Vertex Colors](material-tools.md) window reference.

## ![Material Tools icon](images/icons/Panel_Materials.png) Material Editor

Use the **Material Editor** window to apply Materials to objects or faces.

For more information, see the [Material Editor](material-tools.md) window reference.

## ![UV Editor icon](images/icons/Panel_UVEditor.png) UV Editor

Use the **UV Editor** window to apply textures to objects or faces. You can also use it to automatically or manually wrap and unwrap textures.

For more information, see the [UV Editor](uv-editor.md) window reference.

