using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class EnemyAI : MonoBehaviour
{
    public string hitTag;
    public bool lookingAtPlayer = false;
    public GameObject TheEnemy;

    public bool isAttacking = false;

    // Update is called once per frame
    void Update()
    {
        RaycastHit Hit;
        if (Physics.Raycast(transform.position, transform.TransformDirection(Vector3.forward), out Hit))
        {
            hitTag = Hit.transform.tag;

        }

        if (hitTag == "Player" && isAttacking == false)
        {

  
            StartCoroutine(EnemyAttack());
        }

        if (hitTag != "Player")

        {
            TheEnemy.GetComponent<Animator>().Play("idle");
            lookingAtPlayer = false;
        }
    }

    IEnumerator EnemyAttack()
    {
        isAttacking = true;
        TheEnemy.GetComponent<Animator>().Play("attackinplace");
        lookingAtPlayer = true;
        yield return new WaitForSeconds(1);
        isAttacking = false;
        GlobalHealth.healthValue -= 5;
        
        
    }
}