using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class EnemyHealthManager : MonoBehaviour
{
    public int maxHealth = 1;
    private int currentHealth;

    public int zapSound;

    public GameObject zapEffect, itemToDrop;

    // Start is called before the first frame update
    void Start()
    {
        currentHealth = maxHealth;
    }

    // Update is called once per frame
    void Update()
    {
        
    }

    public void TakeDamage()
    {
        currentHealth--;
        if(currentHealth <= 0)
        {
            AudioManager.instance.PlaySFX(zapSound);

            Destroy(gameObject);

            PlayerController.instance.Bounce();

            Instantiate(zapEffect, transform.position + new Vector3(0, 1.2f, 0), transform.rotation);

            Instantiate(itemToDrop, transform.position + new Vector3(0, 0.5f, 0), transform.rotation);

        }
    }
}
